/*
  DHT20 Example
*/

#include <Wire.h>
#include <DHT20.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128    // OLED display width, in pixels
#define SCREEN_HEIGHT 64    // OLED display height, in pixels
#define OLED_RESET     -1   // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C 

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
DHT20 DHT;

void setup()
{
  Serial.begin(9600);

  Wire.begin();
  DHT.begin();  

  if(!display.begin(SSD1306_SWITCHCAPVCC, SCREEN_ADDRESS)) {
    Serial.println(F("SSD1306 error!"));
    while(1); // Don't proceed, loop forever
  }  
}


void loop()
{
  if (millis() - DHT.lastRead() >= 1000)
  {
    int status = DHT.read();

    display.clearDisplay();
    display.setTextSize(2);      
    display.setTextColor(SSD1306_WHITE);  // Draw white text
    display.setCursor(0, 0);              // Start at top-left corner
    display.print("Hum :");
    display.println(DHT.getHumidity(),1);
    display.print("T(C):");
    display.println(DHT.getTemperature(),1);

    display.display();
  }
}


//  -- END OF FILE --
