/*
  DHT20 Example
*/

#include <Wire.h>
#include <DHT20.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>

#define SCREEN_WIDTH 128    // OLED display width, in pixels
#define SCREEN_HEIGHT 64    // OLED display height, in pixels
#define OLED_RESET     -1   // Reset pin # (or -1 if sharing Arduino reset pin)
#define SCREEN_ADDRESS 0x3C 

Adafruit_SSD1306 display(SCREEN_WIDTH, SCREEN_HEIGHT, &Wire, OLED_RESET);
DHT20 DHT;

void setup()
{
  Serial.begin(9600);

  Wire.begin();
  DHT.begin();  

  Serial.println("Humidity (%)\tTemp (°C)");
  delay(1000);
}


void loop()
{
  if (millis() - DHT.lastRead() >= 1000)
  {
    int status = DHT.read();

    Serial.print(DHT.getHumidity(), 1);
    Serial.print("\t\t");
    Serial.println(DHT.getTemperature(), 1);
  }
  // Do something else...
}


//  -- END OF FILE --
